#!/bin/sh
echo root::0:0:root,,,:/root:/bin/sh >/etc/passwd
/usr/sbin/inetd &

SDA1_LOG_FILE=/mnt/sda1/revert_stock_ujb.log
SUCCESS_MSG="Undo JB successfully done"
ALREADYDONE_MSG="Error : Undo jailbreak already successfully done, please remove this log file to run again the AutoScript"

log () {
	echo "$1" >>${SDA1_LOG_FILE} 2>&1
}

End_of_installation () {
	log "$1"
	sync
	sync
}

if [ -f ${SDA1_LOG_FILE} ] && [ $(cat ${SDA1_LOG_FILE}|grep -c "${SUCCESS_MSG}") -ne 0 ]; then
	[ ! -f /usr/local/bin/bdpprog.1 ] && exit #Undo Jailbreak just completed => exit without message
	[ $(cat ${SDA1_LOG_FILE}|grep -c "${ALREADYDONE_MSG}") -eq 0 ] && log "${ALREADYDONE_MSG}" && sync && sync
	exit
fi


> ${SDA1_LOG_FILE}

if [ ! -f /usr/local/bin/bdpprog.1 ]; then
	log "Error : Undo Jailbreak cannot be done on Official Firmware"
	sync
	sync
	exit
fi


main20x=$(echo /mnt/sda1/MAIN20X*.bin)
if [ $(ls $main20x|grep -c "MAIN20X") -gt 1 ]; then
	log "Error : more than one Official DECRYPTED FW binary file found : put only the one relating to your region"
	sync
	sync
	exit
fi


if [ -f ${main20x} ]; then
	region=$(echo $main20x | sed 's/\/mnt\/sda1\/MAIN20X//' | sed 's/\.bin//' | awk '{print tolower($0)}')
	[ -z "$region" ] && region=us
	list_regions="us ru eu au cn jp tw"
	if [[ ! " $list_regions " =~ .*\ $region\ .* ]]; then
		log "Error : ${main20x} with invalid region : ${region}"
		sync
		sync
		exit
	fi
fi

if [ ! -f ${main20x} ] || [ ! -f /mnt/sda1/UDP20XRU.bin ]; then
	log "Error : missing prerequisite file(s)"
	sync
	sync
	exit
fi

log "Revert to stock FW"
echo -e "drv.ir.rx.sq 0x10000\nquit" | cliprog	#Invalid command, the screen returns to normal
echo -e "drv.ir.rx.sq 0x8f001\nquit" | cliprog	#SETUP
echo -e "drv.ir.rx.sq 0x3f002\nquit" | cliprog	#UP
echo -e "drv.ir.rx.sq 0x3f002\nquit" | cliprog	#UP
echo -e "drv.ir.rx.sq 0x3f002\nquit" | cliprog	#UP
echo -e "drv.ir.rx.sq 0x4f000\nquit" | cliprog	#Select
echo -e "drv.ir.rx.sq 0x3f003\nquit" | cliprog	#Down
echo -e "drv.ir.rx.sq 0x4f000\nquit" | cliprog	#Select
echo -e "drv.ir.rx.sq 0x4f000\nquit" | cliprog	#Select
sleep 3s
if [ -d /tmp/UPG ]; then
	sleep 14s
	if [ -f /tmp/UPG/VER.ini ]; then
		log "Copy ${main20x} to /mnt/sda1/MAIN20XRU.bin"
		cp $main20x /tmp/UPG/MAIN20XRU.bin
		sync
		sync
		echo -e "drv.ir.rx.sq 0x3f000\nquit" | cliprog	#Left
		sleep 1s
		echo -e "drv.ir.rx.sq 0x4f000\nquit" | cliprog	#Select
		sleep 1s
		echo -e "drv.ir.rx.sq 0x4f000\nquit" | cliprog	#Select
		End_of_installation "${SUCCESS_MSG}"
		exit
	fi
fi
log "Error : UGD failure => invalid ${main20x} or /mnt/sda1/UDP20XRU.bin"
End_of_installation "Error : Undo JB failed, back to current FW"
echo -e "drv.ir.rx.sq 0x4f000\nquit" | cliprog	#Select
echo -e "drv.ir.rx.sq 0x9f001\nquit" | cliprog	#Return
